<?php
require_once __DIR__ . '/../../app/config.php';

$in = rp_json_input();
$email = trim(strtolower($in['email'] ?? ''));
$pass  = (string)($in['password'] ?? '');

if (!filter_var($email, FILTER_VALIDATE_EMAIL) || strlen($pass) < 8) {
  rp_json(['ok'=>false,'error'=>'Ongeldige invoer'], 422);
}

$stmt = $pdo->prepare('SELECT id, email, password_hash, full_name, role, department_id, is_active
                       FROM users WHERE email = ? LIMIT 1');
$stmt->execute([$email]);
$user = $stmt->fetch();

if (!$user || !$user['is_active'] || !rp_password_verify($pass, $user['password_hash'])) {
  rp_json(['ok'=>false,'error'=>'E-mailadres of wachtwoord onjuist'], 401);
}

$pdo->prepare('UPDATE users SET last_login_at = NOW() WHERE id = ?')->execute([$user['id']]);

// controle: minstens 1 afdeling?
$cntStmt = $pdo->prepare('SELECT COUNT(*) AS c FROM user_departments WHERE user_id = ?');
$cntStmt->execute([$user['id']]);
$deptCount = (int)($cntStmt->fetch()['c'] ?? 0);

$firstName = $user['full_name'] ? rp_first_name($user['full_name']) : rp_first_name($user['email']);
$needs_profile = empty($user['full_name']) || $deptCount === 0;

$_SESSION['user'] = [
  'id' => (int)$user['id'],
  'email' => $user['email'],
  'full_name' => $user['full_name'] ?: '',
  'first_name' => $firstName,
  'role' => $user['role'] ?: 'member',
  'department_id' => $user['department_id'] // blijft primaire afdeling
];

rp_json(['ok'=>true, 'user'=>[
  'id'=>(int)$user['id'],
  'email'=>$user['email'],
  'first_name'=>$firstName,
  'role'=>$user['role'] ?: 'member',
  'needs_profile'=>$needs_profile
]]);
