<?php
require_once __DIR__ . '/../../app/config.php';

$in = rp_json_input();
$email = trim(strtolower($in['email'] ?? ''));
$pass  = (string)($in['password'] ?? '');
$code  = strtoupper(trim((string)($in['inviteCode'] ?? '')));

if (!filter_var($email, FILTER_VALIDATE_EMAIL) || strlen($pass) < 8 || !preg_match('/^[A-Z0-9-]{6,}$/', $code)) {
  rp_json(['ok'=>false,'error'=>'Ongeldige invoer'], 422);
}

try {
  $pdo->beginTransaction();

  // Check code
  $stmt = $pdo->prepare('SELECT * FROM invite_codes WHERE code = ? AND is_active = 1 AND (expires_at IS NULL OR expires_at > NOW()) LIMIT 1');
  $stmt->execute([$code]);
  $invite = $stmt->fetch();
  if (!$invite) { throw new Exception('Uitnodigingscode ongeldig of verlopen'); }
  if (!is_null($invite['max_uses']) && $invite['uses'] >= $invite['max_uses']) { throw new Exception('Uitnodigingscode maximum bereikt'); }

  // Bestaat user al?
  $check = $pdo->prepare('SELECT id FROM users WHERE email = ? LIMIT 1');
  $check->execute([$email]);
  if ($check->fetch()) { throw new Exception('E-mailadres is al in gebruik'); }

  // Maak user
  $hash = rp_password_hash($pass);
  $ins = $pdo->prepare('INSERT INTO users (email, password_hash, invite_code_id, created_at, updated_at) VALUES (?, ?, ?, NOW(), NOW())');
  $ins->execute([$email, $hash, $invite['id']]);
  $userId = (int)$pdo->lastInsertId();

  // Verhoog uses
  $upd = $pdo->prepare('UPDATE invite_codes SET uses = uses + 1 WHERE id = ?');
  $upd->execute([$invite['id']]);

  $pdo->commit();

  // Start sessie voor nieuwe gebruiker (nog geen naam/dept → onboarding verplicht)
  $_SESSION['user'] = [
    'id' => $userId,
    'email' => $email,
    'full_name' => '',
    'first_name' => rp_first_name($email),
    'role' => 'member',
    'department_id' => null
  ];

  rp_json(['ok'=>true, 'user'=>[
    'id' => $userId,
    'email' => $email,
    'needs_profile' => true
  ]]);
} catch (Exception $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  rp_json(['ok'=>false, 'error'=>$e->getMessage()], 400);
}
