<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login(['admin','manager']); // alleen roostermakers

$in = rp_json_input();
$deptIds = is_array($in['department_ids'] ?? null) ? array_values(array_unique(array_map('intval',$in['department_ids']))) : [];
$search  = trim((string)($in['search'] ?? ''));

// Stap 1: basisselectie gebruikers
$params = [];
$sql = "SELECT u.id, COALESCE(u.full_name,u.email) AS name, u.email
        FROM users u
        WHERE u.is_active=1";

if ($search !== '') {
  $sql .= " AND (u.full_name LIKE ? OR u.email LIKE ?)";
  $params[] = "%$search%"; $params[] = "%$search%";
}
if (!empty($deptIds)) {
  $inph = implode(',', array_fill(0, count($deptIds), '?'));
  $sql .= " AND EXISTS (SELECT 1 FROM user_departments ud WHERE ud.user_id=u.id AND ud.department_id IN ($inph))";
  $params = array_merge($params, $deptIds);
}
$sql .= " ORDER BY u.full_name IS NULL, u.full_name, u.email";

$stm = $pdo->prepare($sql);
$stm->execute($params);
$users = $stm->fetchAll();

if (!$users) {
  rp_json(['ok'=>true,'items'=>[]]);
}

// ids voor vervolgstappen
$userIds = array_map(fn($r)=>(int)$r['id'],$users);
$phU = implode(',', array_fill(0, count($userIds), '?'));

// Stap 2: afdelingen per user
$depsByUser = [];
if ($phU){
  $stm2 = $pdo->prepare("SELECT ud.user_id, d.id, d.name
                         FROM user_departments ud
                         JOIN departments d ON d.id=ud.department_id
                         WHERE ud.user_id IN ($phU)");
  $stm2->execute($userIds);
  foreach ($stm2->fetchAll() as $r) {
    $uid=(int)$r['user_id'];
    $depsByUser[$uid][] = ['id'=>(int)$r['id'], 'name'=>$r['name']];
  }
}

// Stap 3: beschikbaarheid ophalen (ondersteunt beide varianten)
$daysByUser = []; // [uid][1..7] => [ [start,end], ... ]

// check welke tabel bestaat
$hasUA = (bool)$pdo->query("SHOW TABLES LIKE 'user_availability'")->fetchColumn();
$hasA  = (bool)$pdo->query("SHOW TABLES LIKE 'availability'")->fetchColumn();

if ($hasUA) {
  $stm3 = $pdo->prepare("SELECT user_id, weekday, start_time, end_time FROM user_availability WHERE user_id IN ($phU)");
  $stm3->execute($userIds);
  foreach ($stm3->fetchAll() as $r) {
    $uid=(int)$r['user_id']; $w=(int)$r['weekday'];
    $daysByUser[$uid][$w][] = ['start'=>$r['start_time'], 'end'=>$r['end_time']];
  }
} elseif ($hasA) {
  $stm3 = $pdo->prepare("SELECT user_id, weekday, available_from AS start_time, available_to AS end_time FROM availability WHERE user_id IN ($phU)");
  $stm3->execute($userIds);
  foreach ($stm3->fetchAll() as $r) {
    $uid=(int)$r['user_id']; $w=(int)$r['weekday'];
    $daysByUser[$uid][$w][] = ['start'=>$r['start_time'], 'end'=>$r['end_time']];
  }
} else {
  // Geen tabellen: laat alles leeg (onbekend)
}

$items = [];
foreach ($users as $u) {
  $uid = (int)$u['id'];
  $obj = [
    'id'    => $uid,
    'name'  => $u['name'] ?: $u['email'],
    'email' => $u['email'],
    'departments' => array_values($depsByUser[$uid] ?? []),
    'days'  => []
  ];
  // Zorg dat alle dagen bestaan (1..7)
  for ($w=1;$w<=7;$w++){
    $obj['days'][$w] = array_values($daysByUser[$uid][$w] ?? []);
  }
  $items[] = $obj;
}

rp_json(['ok'=>true,'items'=>$items]);
