<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login(['admin','manager']);

$in = rp_json_input();
$name = trim($in['name'] ?? '');
if ($name === '') rp_json(['ok'=>false,'error'=>'Naam is verplicht'], 422);

try {
  $stmt = $pdo->prepare('INSERT INTO departments (name) VALUES (?)');
  $stmt->execute([$name]);
  rp_json(['ok'=>true, 'id'=>(int)$pdo->lastInsertId()]);
} catch (Exception $e) {
  rp_json(['ok'=>false,'error'=>'Afdeling bestaat al of ongeldig'], 400);
}
