<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login();

$in = rp_json_input();
$start = isset($in['start']) ? date('Y-m-d', strtotime($in['start'])) : null;
$end   = isset($in['end'])   ? date('Y-m-d', strtotime($in['end']))   : null;
$deptFilter = isset($in['include_departments']) && is_array($in['include_departments']) ? array_map('intval', $in['include_departments']) : [];

if (!$start || !$end) {
  // default: huidige week (ma–zo)
  $ts = time();
  $dow = (int)date('N', $ts); // 1=ma
  $monday = strtotime('-'.($dow-1).' days', $ts);
  $sunday = strtotime('+'.(7-$dow).' days', $ts);
  $start = date('Y-m-d', $monday);
  $end   = date('Y-m-d', $sunday);
}

$userId = (int)$_SESSION['user']['id'];
$startDT = $start.' 00:00:00';
$endDT   = $end.' 23:59:59';

// Mijn diensten
$sqlMy = "SELECT s.id AS shift_id, s.department_id, d.name AS department_name, s.title, s.start_at, s.end_at
          FROM shifts s
          JOIN shift_assignments sa ON sa.shift_id = s.id
          JOIN departments d ON d.id = s.department_id
          WHERE sa.user_id = ? AND s.start_at <= ? AND s.end_at >= ?
          ORDER BY s.start_at ASC";
$stm = $pdo->prepare($sqlMy);
$stm->execute([$userId, $endDT, $startDT]);
$my = $stm->fetchAll();

// Collega’s per geselecteerde afdelingen (optioneel)
$colleagues = [];
if (!empty($deptFilter)) {
  $inPh = implode(',', array_fill(0, count($deptFilter), '?'));
  $params = array_merge([$startDT, $endDT], $deptFilter);
  $sqlCol = "SELECT s.id AS shift_id, s.department_id, d.name AS department_name,
                    u.id AS user_id, COALESCE(u.full_name, u.email) AS user_name,
                    s.start_at, s.end_at
             FROM shifts s
             JOIN shift_assignments sa ON sa.shift_id = s.id
             JOIN users u ON u.id = sa.user_id
             JOIN departments d ON d.id = s.department_id
             WHERE s.start_at <= ? AND s.end_at >= ? AND s.department_id IN ($inPh)
             ORDER BY s.start_at ASC";
  $stm2 = $pdo->prepare($sqlCol);
  $stm2->execute($params);
  $rows = $stm2->fetchAll();

  foreach ($rows as $r) {
    $deptId = (int)$r['department_id'];
    if (!isset($colleagues[$deptId])) $colleagues[$deptId] = [];
    $colleagues[$deptId][] = $r;
  }
}

// Bundel per dag
$days = [];
$cursor = strtotime($start);
$endTs = strtotime($end);
for ($t = $cursor; $t <= $endTs; $t += 86400) {
  $days[date('Y-m-d', $t)] = ['date' => date('Y-m-d', $t), 'my' => [], 'colleagues' => []];
}
foreach ($my as $m) {
  $d = date('Y-m-d', strtotime($m['start_at']));
  if (isset($days[$d])) $days[$d]['my'][] = $m;
}
foreach ($colleagues as $deptId => $rows) {
  foreach ($rows as $r) {
    $d = date('Y-m-d', strtotime($r['start_at']));
    if (!isset($days[$d])) continue;
    if (!isset($days[$d]['colleagues'][$deptId])) $days[$d]['colleagues'][$deptId] = ['department_name'=>$r['department_name'],'items'=>[]];
    $days[$d]['colleagues'][$deptId]['items'][] = $r;
  }
}

rp_json(['ok'=>true, 'range'=>['start'=>$start, 'end'=>$end], 'days'=>array_values($days)]);
