<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login();

$in = rp_json_input();
$current = (string)($in['current_password'] ?? '');
$new     = (string)($in['new_password'] ?? '');

if (strlen($current) < 1 || strlen($new) < 8) {
  rp_json(['ok'=>false,'error'=>'Nieuw wachtwoord moet minimaal 8 tekens zijn'], 422);
}

$userId = (int)$_SESSION['user']['id'];
$stm = $pdo->prepare('SELECT password_hash FROM users WHERE id=? LIMIT 1');
$stm->execute([$userId]);
$row = $stm->fetch();
if (!$row || !rp_password_verify($current, $row['password_hash'])) {
  rp_json(['ok'=>false,'error'=>'Huidig wachtwoord klopt niet'], 400);
}

$hash = rp_password_hash($new);
$upd = $pdo->prepare('UPDATE users SET password_hash=?, updated_at=NOW() WHERE id=?');
$upd->execute([$hash, $userId]);

rp_json(['ok'=>true]);
