<?php
require_once __DIR__ . '/../../app/config.php';
rp_require_login();

$in = rp_json_input();
$first = trim($in['first_name'] ?? '');
$last  = trim($in['last_name'] ?? '');
$deptIds = $in['department_ids'] ?? []; // array
$phoneRaw = isset($in['phone']) ? trim((string)$in['phone']) : null;

if ($first === '' || $last === '' || !is_array($deptIds) || count($deptIds) < 1) {
  rp_json(['ok'=>false,'error'=>'Voornaam, achternaam en minimaal één afdeling zijn verplicht'], 422);
}

// normaliseer ids
$deptIds = array_values(array_unique(array_map(fn($v)=> (int)$v, $deptIds)));
$deptIds = array_filter($deptIds, fn($v)=> $v > 0);
if (count($deptIds) < 1) rp_json(['ok'=>false,'error'=>'Kies minimaal één geldige afdeling'], 422);

// valideer afdelingen
$ph = implode(',', array_fill(0, count($deptIds), '?'));
$chk = $pdo->prepare("SELECT id FROM departments WHERE is_active=1 AND id IN ($ph)");
$chk->execute($deptIds);
$found = $chk->fetchAll(PDO::FETCH_COLUMN);
if (count($found) !== count($deptIds)) rp_json(['ok'=>false,'error'=>'Eén of meer afdelingen zijn ongeldig'], 422);

// phone normaliseren (optioneel)
$phone = null;
if ($phoneRaw !== null && $phoneRaw !== '') {
  $phone = rp_normalize_nl_mobile($phoneRaw);
  if (!$phone) rp_json(['ok'=>false,'error'=>'Ongeldig 06-nummer'], 422);
}

$userId = $_SESSION['user']['id'];
$full = trim("$first $last");

try {
  $pdo->beginTransaction();

  // update naam, primaire afdeling en telefoon
  $primary = $deptIds[0];
  $sql = 'UPDATE users SET full_name=?, department_id=?, updated_at=NOW()';
  $args = [$full, $primary, $userId];
  if ($phone !== null) { $sql .= ', phone=?'; array_splice($args, 2, 0, [$phone]); }
  $sql .= ' WHERE id=?';
  $upd = $pdo->prepare($sql);
  $upd->execute($args);

  // vervang koppelingen
  $pdo->prepare('DELETE FROM user_departments WHERE user_id=?')->execute([$userId]);
  $ins = $pdo->prepare('INSERT INTO user_departments (user_id, department_id) VALUES (?, ?)');
  foreach ($deptIds as $id) { $ins->execute([$userId, $id]); }

  $pdo->commit();

  // sessie updaten
  $_SESSION['user']['full_name'] = $full;
  $_SESSION['user']['first_name'] = $first;
  $_SESSION['user']['department_id'] = $primary;

  rp_json(['ok'=>true]);
} catch (Exception $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  rp_json(['ok'=>false,'error'=>'Kon profiel niet opslaan'], 500);
}
