'use strict';

(function(){
  const daysEl = document.getElementById('days');
  const note = document.getElementById('note');
  const saveBtn = document.getElementById('save');
  const labels = ['Maandag','Dinsdag','Woensdag','Donderdag','Vrijdag','Zaterdag','Zondag'];

  function dayCard(i){
    const wrap = document.createElement('div'); wrap.className='day'; wrap.dataset.day=i;
    wrap.innerHTML = `<h3>${labels[i-1]}</h3><div class="slots"></div><button type="button" class="add">+ Tijdvak</button>`;
    wrap.querySelector('.add').addEventListener('click', ()=> addSlot(wrap));
    return wrap;
  }
  function addSlot(dayWrap, from='09:00', to='17:00'){
    const row = document.createElement('div'); row.className='slot';
    row.innerHTML = `<input type="time" class="from" value="${from}"><span>–</span><input type="time" class="to" value="${to}"><button class="rm" type="button">×</button>`;
    row.querySelector('.rm').addEventListener('click', ()=> row.remove());
    dayWrap.querySelector('.slots').appendChild(row);
  }

  function show(msg, ok=false){ note.hidden=false; note.textContent=msg; note.style.color = ok ? '#065f46' : '#111827'; }

  // Init UI
  for (let i=1;i<=7;i++) daysEl.appendChild(dayCard(i));

  // Load existing
  fetch('/api/availability/get.php').then(r=>r.json()).then(d=>{
    if (!d.ok) return;
    d.items.forEach(it=>{
      const w = daysEl.querySelector(`.day[data-day="${it.weekday}"]`);
      addSlot(w, it.start_time.slice(0,5), it.end_time.slice(0,5));
    });
  });

  saveBtn.addEventListener('click', async ()=>{
    const slots = [];
    daysEl.querySelectorAll('.day').forEach(day=>{
      const wd = parseInt(day.dataset.day,10);
      day.querySelectorAll('.slot').forEach(s=>{
        const a = s.querySelector('.from').value, b = s.querySelector('.to').value;
        if (a && b) slots.push({ weekday: wd, start: a, end: b });
      });
    });
    const res = await fetch('/api/availability/save.php', {
      method:'POST', headers:{'Content-Type':'application/json'},
      body: JSON.stringify({ slots })
    });
    const d = await res.json();
    if (!res.ok || d.ok === false) return show(d.error || 'Opslaan mislukt');
    show('Beschikbaarheid opgeslagen!', true);
  });
})();
