<?php
// Start sessie vroeg
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

/** DB config (zoals je al had)… */
$DB_HOST = '127.0.0.1';
$DB_PORT = '3306';
$DB_NAME = 'rooster';
$DB_USER = 'root';
$DB_PASS = '';
$DB_CHARSET = 'utf8mb4';

$dsn = "mysql:host={$DB_HOST};port={$DB_PORT};dbname={$DB_NAME};charset={$DB_CHARSET}";
$options = [
  PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
  PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  PDO::ATTR_EMULATE_PREPARES => false,
];

if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }


try { $pdo = new PDO($dsn, $DB_USER, $DB_PASS, $options); }
catch (PDOException $e) {
  http_response_code(500);
  header('Content-Type: application/json');
  echo json_encode(['ok' => false, 'error' => 'Databaseverbinding mislukt.']);
  exit;
}

// ===== Helpers (bestaand) =====
function rp_password_hash(string $plain): string { return password_hash($plain, PASSWORD_DEFAULT); }
function rp_password_verify(string $plain, string $hash): bool { return password_verify($plain, $hash); }
function rp_json_input(): array { return json_decode(file_get_contents('php://input') ?: '[]', true) ?: []; }
function rp_json($data, int $code=200): void { http_response_code($code); header('Content-Type: application/json'); echo json_encode($data); exit; }
function rp_first_name(string $fullOrEmail): string {
  if (strpos($fullOrEmail, '@') === false) { $p = preg_split('/\s+/', trim($fullOrEmail)); return ucfirst($p[0] ?? 'Gebruiker'); }
  return ucfirst(explode('@', $fullOrEmail)[0]);
}
/** Normaliseer NL 06-nummer naar +316######## (laat leeg toe) */
function rp_normalize_nl_mobile(?string $raw): ?string {
  if (!$raw) return null;
  $digits = preg_replace('/\D+/', '', $raw);
  if (preg_match('/^06(\d{8})$/', $digits, $m)) return '+316'.$m[1];
  if (preg_match('/^6(\d{8})$/', $digits, $m))  return '+316'.$m[1];
  if (preg_match('/^00316(\d{8})$/', $digits, $m)) return '+316'.$m[1];
  if (preg_match('/^316(\d{8})$/', $digits, $m)) return '+316'.$m[1];
  if (preg_match('/^\+316(\d{8})$/', $raw, $m))  return '+316'.$m[1];
  return null;
}

// ===== 🆕 Sessiesync: rol/naam/afdeling altijd actueel =====
function rp_session_sync(): void {
  if (empty($_SESSION['user']['id'])) return;
  static $synced = false;
  if ($synced) return; // één keer per request is genoeg
  $synced = true;

  // Gebruik hier de globale PDO
  global $pdo;
  try {
    $stm = $pdo->prepare('SELECT id, email, full_name, role, department_id FROM users WHERE id = ? LIMIT 1');
    $stm->execute([ (int)$_SESSION['user']['id'] ]);
    if ($row = $stm->fetch()) {
      $_SESSION['user']['email'] = $row['email'];
      $_SESSION['user']['full_name'] = $row['full_name'] ?: '';
      $_SESSION['user']['first_name'] = $row['full_name'] ? rp_first_name($row['full_name']) : rp_first_name($row['email']);
      $_SESSION['user']['role'] = $row['role'] ?: 'member';
      $_SESSION['user']['department_id'] = $row['department_id'];
    } else {
      // user verdwenen? uitloggen
      $_SESSION = [];
    }
  } catch (Throwable $e) {
    // bij fout doen we niets; sessie blijft zoals was
  }
}

function rp_user(): ?array {
  rp_session_sync();
  return $_SESSION['user'] ?? null;
}

function rp_require_login(array $roles = null): void {
  rp_session_sync();
  if (empty($_SESSION['user'])) rp_json(['ok'=>false,'error'=>'Niet ingelogd'], 401);
  if ($roles && !in_array($_SESSION['user']['role'] ?? 'member', $roles, true)) {
    rp_json(['ok'=>false,'error'=>'Geen rechten'], 403);
  }
}