'use strict';

(function(){
  const body = document.body;
  const firstName = body.getAttribute('data-firstname') || 'gebruiker';

  // Greeting
  const greetEl = document.getElementById('greet');
  const hour = new Date().getHours();
  let prefix = 'Goedendag';
  if (hour >= 5 && hour < 12) prefix = 'Goedemorgen';
  else if (hour >= 12 && hour < 18) prefix = 'Goedemiddag';
  else if (hour >= 18 && hour < 24) prefix = 'Goedenavond';
  else prefix = 'Goedenacht';
  greetEl.textContent = `${prefix} ${firstName}`;

  // Toast
  const toast = document.getElementById('toast');
  const toastMsg = document.getElementById('toastMsg');
  const toastClose = document.getElementById('toastClose');
  let hideTimer = null;

  function showToast(message){
    toastMsg.textContent = message;
    toast.classList.add('show');
    toast.setAttribute('aria-hidden','false');
    if (hideTimer) clearTimeout(hideTimer);
    hideTimer = setTimeout(hideToast, 5000); // auto-hide na 5s
  }
  function hideToast(){ toast.classList.remove('show'); toast.setAttribute('aria-hidden','true'); }
  toastClose.addEventListener('click', hideToast);

  try {
    const raw = sessionStorage.getItem('rp_welcome');
    if (raw) {
      const data = JSON.parse(raw);
      if (data && data.msg) showToast(`Welkom terug, ${firstName}!`);
      sessionStorage.removeItem('rp_welcome');
    }
  } catch(_) {}
})();
