<?php
require_once __DIR__ . '/../config.php';
rp_require_login();

$u = rp_user();
$profileComplete = !empty($u['full_name']) && !empty($u['department_id']);
if (!$profileComplete) {
  header('Location: /app/onboarding/');
  exit;
}

$firstName = $u['first_name'] ?: rp_first_name($u['full_name'] ?: $u['email']);
$role = $u['role'] ?? 'member';
$isMgr = in_array($role, ['admin','manager'], true);
?>
<!DOCTYPE html>
<html lang="nl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Roosterprogramma – Dashboard</title>
  <link rel="stylesheet" href="style.css" />
</head>
<body data-firstname="<?= htmlspecialchars($firstName, ENT_QUOTES) ?>" data-role="<?= htmlspecialchars($role, ENT_QUOTES) ?>">
  <header class="topbar">
    <div class="brand">Mediamarkt Beschikbaarheid</div>
    <nav class="nav">
      <a href="/app/dashboard/index.php" class="navlink active">Dashboard</a>
      <?php if ($isMgr): ?>
        <a href="/app/announcements/manage.php" class="navlink">Acties &amp; meldingen</a>
        <a href="/app/availability/overview.php" class="navlink">Beschikbaarheid bekijken</a>
      <?php endif; ?>
      <a href="/app/availability/" class="navlink">Mijn beschikbaarheid</a>
      <a href="/app/profile/" class="navlink">Mijn profiel</a>
    </nav>
    <div class="spacer"></div>
    <a class="navlink" href="/api/auth/logout.php">Log uit</a>
  </header>

  <section class="hero">
    <div class="hero-inner">
      <h1 id="greet">Welkom</h1>
      <p class="muted">Je persoonlijke overzicht</p>
    </div>
  </section>

  <main class="container">
    <section class="quick">
      <a class="qcard" href="/app/availability/">
        <div class="qicon">🗓️</div>
        <div class="qtitle">Mijn Beschikbaarheid</div>
      </a>
      <?php if ($isMgr): ?>
        <a class="qcard" href="/app/availability/overview.php">
          <div class="qicon">📅</div>
          <div class="qtitle">Beschikbaarheid inzien</div>
        </a>
        <a class="qcard" href="/app/announcements/manage.php">
          <div class="qicon">📣</div>
          <div class="qtitle">Acties &amp; meldingen beheren</div>
        </a>
      <?php endif; ?>
      <a class="qcard" href="/app/profile/">
        <div class="qicon">🧑</div>
        <div class="qtitle">Mijn profiel</div>
      </a>
    </section>

    <section class="grid">
      <!-- ❗️Koppen aangepast zodat de hook ze exact vindt -->
      <article class="card">
        <h2 class="card-title">Lopende acties</h2>
        <p class="muted">Nog geen items.</p>
      </article>
      <article class="card">
        <h2 class="card-title">Teamactiviteiten</h2>
        <p class="muted">Nog geen items.</p>
      </article>
      <article class="card">
        <h2 class="card-title">Meldingen</h2>
        <p class="muted">Nog geen items.</p>
      </article>
    </section>
  </main>

  <!-- Toast rechtsboven -->
  <div id="toast" class="toast" role="status" aria-live="polite" aria-hidden="true">
    <span id="toastIcon" class="toast-icon">🎉</span>
    <span id="toastMsg"></span>
    <button id="toastClose" class="toast-close" aria-label="Sluiten">×</button>
  </div>

  <!-- Scripts -->
  <script src="/app/announcements/hook-dashboard.js" defer></script>
  <script src="app.js"></script>
</body>
</html>
