<!DOCTYPE html>
<html lang="nl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Roosterprogramma – Inloggen / Account met Code</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="style.css" />
</head>
<body>
  <main class="card" role="main">
    <header class="card-header">
      <svg class="icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><path d="M15 3h4a2 2 0 0 1 2 2v4"/><path d="M10 14 21 3"/><path d="M19 21h-4a2 2 0 0 1-2-2v-4"/><path d="M14 10 3 21"/></svg>
      <div>
        <h1 id="headline" class="card-title">Inloggen</h1>
        <p id="subline" class="card-desc">Welkom terug. Log in om door te gaan.</p>
      </div>
    </header>

    <section class="card-content">
      <div id="notice" class="notice" role="status" aria-live="polite">
        <span id="noticeIcon" aria-hidden="true">⚠️</span>
        <span id="noticeMsg"></span>
      </div>

      <form id="authForm" novalidate>
        <div id="inviteField" class="field" hidden>
          <label for="invite">Uitnodigingscode</label>
          <div class="input-wrap">
            <input id="invite" name="invite" type="text" placeholder="BV: ABCD-1234" inputmode="latin" autocomplete="one-time-code" />
            <span class="affix" aria-hidden="true">🔐</span>
          </div>
          <p class="hint">Ontvangen van je beheerder of organisatie</p>
        </div>

        <div class="field">
          <label for="email">E-mailadres</label>
          <div class="input-wrap">
            <input id="email" name="email" type="email" placeholder="jij@voorbeeld.nl" autocomplete="email" required />
            <span class="affix" aria-hidden="true">✉️</span>
          </div>
        </div>

        <div class="field">
          <label for="password">Wachtwoord</label>
          <div class="input-wrap">
            <input id="password" name="password" type="password" placeholder="Minimaal 8 tekens" autocomplete="current-password" required />
            <button id="togglePw" type="button" class="affix" aria-label="Toon wachtwoord">👁️</button>
          </div>
          <button type="button" id="forgot" class="forgot">Wachtwoord vergeten?</button>
        </div>

        <div class="card-footer">
          <button id="submitBtn" type="submit" class="btn">Inloggen</button>
          <div class="linkbar">
            <span id="switchText">Nog geen account?</span>
            <button id="switchView" type="button" class="switch-cta" aria-label="Maak een account met code">
              <span>Maak een account met code</span>
              <svg class="chev" viewBox="0 0 24 24" width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><path d="M9 18l6-6-6-6"/></svg>
            </button>
          </div>
          <p class="fineprint">Door door te gaan ga je akkoord met de voorwaarden van Roosterprogramma.
            <a class="link" href="#">Voorwaarden</a> • <a class="link" href="#">Privacy</a>
          </p>
        </div>
      </form>
    </section>

    <p class="tip">Tip: voor staging kun je codes als <code>ABCD-1234</code> of <code>TEAM-INVITE</code> gebruiken.</p>
  </main>

  <script src="app.js"></script>
</body>
</html>
