<?php
require_once __DIR__ . '/../config.php';
rp_require_login();
$u = rp_user();
$profileComplete = !empty($u['full_name']); // afdelingcontrole gebeurt in login en na update
if ($profileComplete) { /* we checken straks in JS of er afdelingen zijn gekozen */ }
?>
<!DOCTYPE html>
<html lang="nl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Profiel aanvullen – Roosterprogramma</title>
  <link rel="stylesheet" href="style.css">
</head>
<body>
  <main class="onb">
    <header>
      <h1>Welkom! Eerst even je profiel aanvullen</h1>
      <p class="muted">Vul je naam in en kies <strong>minstens één</strong> afdeling (meerdere mag ook).</p>
    </header>

    <form id="onbForm" class="card" novalidate>
      <div class="row">
        <div class="field">
          <label for="first">Voornaam</label>
          <input id="first" type="text" required />
        </div>
        <div class="field">
          <label for="last">Achternaam</label>
          <input id="last" type="text" required />
        </div>
      </div>

      <div class="field">
        <label>Afdelingen</label>
        <div id="deptList" class="checks"></div>
        <small class="muted" id="deptHelp">Kies minimaal één afdeling.</small>
      </div>

      <div class="actions">
        <button type="submit" class="btn">Opslaan en verder</button>
        <a class="link" href="/api/auth/logout.php">Annuleren</a>
      </div>

      <div id="note" class="note" hidden></div>
    </form>
  </main>

  <script src="app.js"></script>
</body>
</html>
