<?php
// /scripts/migrate_announcements.php  (v2 - robuste FK-setup)
// - Leest COLUMN_TYPE van users.id / departments.id / announcements.id
// - Maakt tabellen zonder FKs, voegt FKs daarna toe met ALTER TABLE
// - Print duidelijke foutuitleg bij FK-fouten

require_once __DIR__ . '/../app/config.php';
rp_require_login(['admin','manager']);
header('Content-Type: text/plain; charset=utf-8');

function qv($pdo,$sql,$p=[]){$s=$pdo->prepare($sql);$s->execute($p);return $s->fetchColumn();}
function ensureInnoDB($pdo,$t){
  $e=qv($pdo,"SELECT ENGINE FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME=?",[$t]);
  if(!$e) throw new Exception("Tabel `$t` bestaat niet"); if(strtolower($e)!=='innodb'){ echo "• ALTER TABLE `$t` ENGINE=InnoDB … "; $pdo->exec("ALTER TABLE `$t` ENGINE=InnoDB"); echo "OK\n"; }
  else echo "• `$t` is al InnoDB\n";
}
function colType($pdo,$t,$c){
  $ct=qv($pdo,"SELECT COLUMN_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME=? AND COLUMN_NAME=?",[$t,$c]);
  if(!$ct) throw new Exception("COLUMN_TYPE onbekend: `$t`.`$c`");
  return strtoupper($ct); // bv "INT(10) UNSIGNED"
}
function dbCharsetCollation($pdo){
  $coll=qv($pdo,"SELECT DEFAULT_COLLATION_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME=DATABASE()");
  $charset = (stripos($coll,'utf8mb4')!==false)?'utf8mb4':((stripos($coll,'utf8')!==false)?'utf8':'utf8mb4');
  return [$charset, $coll ?: 'utf8mb4_unicode_ci'];
}
function innodbLastError($pdo){
  try{
    $row = $pdo->query("SHOW ENGINE INNODB STATUS")->fetch(PDO::FETCH_ASSOC);
    if(!empty($row['Status'])){
      $txt=$row['Status'];
      $p=strpos($txt,"LATEST FOREIGN KEY ERROR");
      if($p!==false) return substr($txt,$p,1200);
      return substr($txt,0,1200);
    }
  }catch(Exception $e){}
  return null;
}

try{
  echo "== Roosterprogramma • Migratie: announcements (v2)==\n\n";

  echo "[Stap 0] Controle bron-tabellen (users, departments)\n";
  ensureInnoDB($pdo,'users');
  ensureInnoDB($pdo,'departments');

  $usersIdColType = colType($pdo,'users','id');           // bv INT(10) UNSIGNED
  $deptsIdColType = colType($pdo,'departments','id');     // bv INT(10) UNSIGNED
  [$charset,$collation] = dbCharsetCollation($pdo);

  echo "• users.id   type: $usersIdColType\n";
  echo "• departments.id type: $deptsIdColType\n";
  echo "• DB charset/collation: $charset / $collation\n\n";

  echo "[Stap 1] Tabellen (zonder FKs) opnieuw aanmaken\n";
  $pdo->exec("SET FOREIGN_KEY_CHECKS=0");
  $pdo->exec("DROP TABLE IF EXISTS `announcement_users`");
  $pdo->exec("DROP TABLE IF EXISTS `announcement_departments`");
  $pdo->exec("DROP TABLE IF EXISTS `announcements`");

  // announcements: neem users.id type over voor consistentie (zelfde ints)
  echo "• CREATE `announcements` … ";
  $pdo->exec("
    CREATE TABLE `announcements` (
      `id` $usersIdColType NOT NULL AUTO_INCREMENT,
      `type` ENUM('activity','notice','special') NOT NULL,
      `title` VARCHAR(160) NOT NULL,
      `message` TEXT NULL,
      `scope` ENUM('global','department','user') NOT NULL DEFAULT 'global',
      `start_at` DATETIME NULL,
      `end_at` DATETIME NULL,
      `created_by` $usersIdColType NULL,
      `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
      `updated_at` TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
      PRIMARY KEY (`id`),
      KEY `idx_type` (`type`),
      KEY `idx_scope` (`scope`),
      KEY `idx_period` (`start_at`,`end_at`)
    ) ENGINE=InnoDB DEFAULT CHARSET=$charset COLLATE=$collation
  ");
  echo "OK\n";

  // Haal nu exact type van announcements.id op
  $annIdColType = colType($pdo,'announcements','id');

  echo "• CREATE `announcement_departments` … ";
  $pdo->exec("
    CREATE TABLE `announcement_departments` (
      `announcement_id` $annIdColType NOT NULL,
      `department_id`   $deptsIdColType NOT NULL,
      PRIMARY KEY (`announcement_id`,`department_id`),
      KEY `idx_ad_department` (`department_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=$charset COLLATE=$collation
  ");
  echo "OK\n";

  echo "• CREATE `announcement_users` … ";
  $pdo->exec("
    CREATE TABLE `announcement_users` (
      `announcement_id` $annIdColType NOT NULL,
      `user_id`         $usersIdColType NOT NULL,
      PRIMARY KEY (`announcement_id`,`user_id`),
      KEY `idx_au_user` (`user_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=$charset COLLATE=$collation
  ");
  echo "OK\n";

  $pdo->exec("SET FOREIGN_KEY_CHECKS=1");

  echo "\n[Stap 2] Foreign keys toevoegen\n";
  // Voeg FK's toe met ALTER TABLE zodat we precieze fout krijgen als het misgaat
  try{
    echo "• FK ad→announcements … ";
    $pdo->exec("ALTER TABLE `announcement_departments`
      ADD CONSTRAINT `fk_ad_a` FOREIGN KEY (`announcement_id`)
      REFERENCES `announcements`(`id`)
      ON DELETE CASCADE ON UPDATE CASCADE");
    echo "OK\n";
  }catch(Exception $e){
    echo "FOUT\n";
    if($info = innodbLastError($pdo)) echo $info."\n";
    throw $e;
  }

  try{
    echo "• FK ad→departments … ";
    $pdo->exec("ALTER TABLE `announcement_departments`
      ADD CONSTRAINT `fk_ad_d` FOREIGN KEY (`department_id`)
      REFERENCES `departments`(`id`)
      ON DELETE CASCADE ON UPDATE CASCADE");
    echo "OK\n";
  }catch(Exception $e){
    echo "FOUT\n";
    if($info = innodbLastError($pdo)) echo $info."\n";
    throw $e;
  }

  try{
    echo "• FK au→announcements … ";
    $pdo->exec("ALTER TABLE `announcement_users`
      ADD CONSTRAINT `fk_au_a` FOREIGN KEY (`announcement_id`)
      REFERENCES `announcements`(`id`)
      ON DELETE CASCADE ON UPDATE CASCADE");
    echo "OK\n";
  }catch(Exception $e){
    echo "FOUT\n";
    if($info = innodbLastError($pdo)) echo $info."\n";
    throw $e;
  }

  try{
    echo "• FK au→users … ";
    $pdo->exec("ALTER TABLE `announcement_users`
      ADD CONSTRAINT `fk_au_u` FOREIGN KEY (`user_id`)
      REFERENCES `users`(`id`)
      ON DELETE CASCADE ON UPDATE CASCADE");
    echo "OK\n";
  }catch(Exception $e){
    echo "FOUT\n";
    if($info = innodbLastError($pdo)) echo $info."\n";
    throw $e;
  }

  echo "\n✅ Klaar! Tabellen + foreign keys staan goed.\n";

} catch(Exception $e){
  http_response_code(500);
  echo "❌ Fout: ".$e->getMessage()."\n";
}
